% LOAD
wd = cd;
logfile = sprintf('%s/log/winning.log',wd(1:end-5));
data = load(logfile);
scorePm = data(:,2);
scorePs = data(:,3);
tPhase = data(:,4);
scorePs(scorePs<scorePs(1)) = Inf;
scoreSw = scorePm;
scoreSw(isfinite(scorePs)) = Inf;

% TOTAL TIME
tTotal = tPhase;
offset = 0;
for i=2:length(tPhase)
  if (tPhase(i)==0)
    offset = offset + tPhase(i-1);
  end
  tTotal(i) = tTotal(i) + offset;
end

% PLOT
figure(3); clf;
set(gcf,'Position',[90 50 1400 812]);
axes('Position',[0.14 0.14 0.82 0.8]);
lc = lines(8);
plot(tTotal,scorePs,'o-','MarkerSize',12,...
  'LineWidth',2,'Color',lc(1,:),'MarkerFaceColor',lc(1,:),'MarkerEdgeColor',lc(1,:));
hold on;
plot(tTotal,scorePm,'^-','MarkerSize',12,'LineWidth',2,...
  'Color',lc(7,:),'MarkerFaceColor',lc(7,:),'MarkerEdgeColor',lc(7,:));
plot(tTotal,scoreSw,'s-','MarkerSize',16,'LineWidth',2,'Color',lc(3,:),...
  'MarkerFaceColor','w','MarkerEdgeColor',lc(3,:));
plot([0 90],[5850000 5850000],'k--','LineWidth',2);
plot(tTotal(isfinite(scorePs)),scorePm(isfinite(scorePs)),'^','MarkerSize',12,'LineWidth',2,...
  'Color',lc(7,:),'MarkerFaceColor',lc(7,:),'MarkerEdgeColor',lc(7,:));
set(gca,'FontSize',32);
set(gca,'LineWidth',3);
% axis([0 60 5837000 5858000]);
axis([0 50 5837000 5858000]);
set(gca,'XTick',[0:10:50]);
set(gca,'YTick',(584:0.5:587)*1e4);
set(gca,'YTickLabel',{'5840K','5845K','5850K','5855K','5860K'});
yl = ylabel('score');
xl = xlabel('minutes');
% set(yl,'Position',[-7.5 5.8475e6 0]);
set(yl,'Position',[-6.8 5.8475e6 0]);
lgd = legend(' doubly stochastic',' permutation (projected)', ' permutation (swaps)');
set(lgd,'Position',[0.64 0.17 0.27 0.15]);
grid on;

% PRINT
set(gcf,'PaperPositionMode','auto');
set(gcf,'PaperUnits','inches','PaperSize',[19 11.5]);
print -dpdf fig_acdc.pdf;
